//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define DEF_INTERACTIVE
//+----------------+
#ifdef DEF_INTERACTIVE
    #define def_OPERATION "Interactive"
#else
    #define def_OPERATION "Recursive"
#endif
//+----------------+
#define def_Fibonacci_Element_Default   11
//+----------------+
#define def_MSG_TERMINAL "Result of " + def_OPERATION + " operation of element"
//+------------------------------------------------------------------+
void OnStart(void)
{
    Print(def_MSG_TERMINAL, " ", def_Fibonacci_Element_Default, " : ", Fibonacci());
}
//+------------------------------------------------------------------+
uint Fibonacci(uint arg = def_Fibonacci_Element_Default)
{
#ifdef DEF_INTERACTIVE

    uint v, i, c;

    for (c = 0, i = 0, v = 1; c < arg; i += v, c += 2)
        v += i;

    return (c == arg ? i : v);

#else    

    if (arg <= 1)
        return arg;

    return Fibonacci(arg - 1) +  Fibonacci(arg - 2);

#endif
}
//+------------------------------------------------------------------+